# Configuration file containing folder locations, data setteing, grouping, plot variables etc.

# NOTE: this is shared between Process_input (PI), Grouped_data (GD), and High vs Low impulsive (HvsL)

# Folders -----------------------------------------------------------------

raw.data.folder <- "./Data/Signal_by_distance"
Impulsivity.groups <- c("high", "low") # subfolder names; make sure ok, as used as factor levels as well
Treatments.groups <- c("BI_compound", "Vehicle") # folder, removed Saline
plots.folder <- "./Plots/Signal_by_distance/"
output.folder <- "./Output/Signal_by_distance/"

log.name = "logz.txt"
threshold = "INFO"
Labels.data.file <- "./Data/Brain_areas_colors.csv" # also Labels.data.file
Matlab.labels.file <- "./Data/Matlab_brain_labels.csv"
Brain.coordinates.file <-  "./Data/BrainNodesCoordinates_corrected.csv"

permute <- FALSE
make.paper.figures <- TRUE
make_paper_p.adjust.method <- "bonferroni"

# Process_input settings --------------------------------------------------------

PI_single.data <- "Correlations_single_data" # file save for single animals
PI_grouped_data <- "Correlations_grouped_data" # file save for mean matrix per group
PI_mu.set = 0
PI_varEqual = TRUE
PI_TSBH <- "TSBH" # p value correction method for one sample t.test

remove.areas <- c('Cortical_subplate_L','Cortical_subplate_R',
                  'Corpus_callosum_L', 'Corpus_callosum_R',
                  'lateral_ventricle_L', 'lateral_ventricle_R',
                  'third_ventricle_L', 'third_ventricle_R',
                  'fourth_ventricle_L', 'fourth_ventricle_R',
                  'white_Matter_L', 'white_Matter_R',
                  'Spinal_cord_L', 'Spinal_cord_R',
				  'Olfactory_Bulb_L', 'Olfactory_Bulb_L',
				  'Hindbrain_L', 'Hindbrain_R',
				  'Midbrain_L', 'Midbrain_L','Triangular_nucleus_of_septum_L','Triangular_nucleus_of_septum_R')

# Grouped_data settings --------------------------------------------------------
GD_make.heatmap <- TRUE # if false no heatmaps/network plots are made
GD_make.network <- FALSE # if false no heatmaps/network plots are made
GD_network <- "Network_OneSampleFiltered"
GD_heatmap <- "Group_mean_heatmap"
GD_delta_heatmap <- "Group_delta_heatmap"
GD.p.filter <- 0.05

# High vs low impulsive settings -----------------------------------------------------
HvsL_edgeTtest_make.plots <- FALSE # if false no heatmaps/network plots are made
HvsL_meanDelta_make.plots <- FALSE # make summary plots for High vs Low

HvsL_p.correction <- "TSBH"
HvsL_p.alpha <- 0.1
HvsL_heatmap.p.filter <- 0.05
HvsL_heatmap <- "HvsL_edgeTtest_heatmap_"

HvsL_edgewise.columns <- c("p.value < 0.05", "corrected.p.value < 0.05")
HvsL_single.hemisphere <- c("TRUE", "FALSE")

HvsL_mean_FisherZ_box <- "HvsL_mean_Regionwise_Fisher"
HvsL_mean_Regionwise_tTest <- "HvsL_mean_Regionwise_tTest"

HvsL_mean_Regionwise_KS <- "HvsL_mean_Regionwise_KS"
HvsL_meanDelta_Regionwise_oneSample <- "HvsL_meanDelta_Regionwise_oneSample"


# Interaction settings ----------------------------------------------------
Interaction_make.heatmap <-  TRUE # if false no heatmaps/network plots are made
Interaction_p.correction <- "TSBH"
Interaction_heatmap.p.filter <- 0.05
Interaction_heatmap <- "Interaction_edge_heatmap"

# Heatmap settings --------------------------------------------------------

Heatmap.color.range <- seq(0, 1, length = 12) # the probability split for quantiles for heatmap

Heatmap.brain.levels <- c("Isocortex", "Olfactory areas", "Hippocapal formation", 
                  "Striatum", "Cortical subplate", "Pallidum",
                  "Thalamus","Hypothalamus","Midbrain",
                  "Hindbrain", "Cerebellum")
Heatmap.brain.colors <- c("#009C75", "#9AD2BD", "#32B825", 
                  "#80CDF8", "#61E7B7", "#8599CC",
                  "#FF7080", "#E64438", "#FF64FF",
                  "#FF9B88", "#F0F080")

Heatmap.Level.color <- data.frame(Parental_brain_region = Heatmap.brain.levels,
                          Color.simplyfied = Heatmap.brain.colors, 
                          stringsAsFactors = FALSE)

